# Van Gogh Museum Collection

This archive contains musical representations of approximately 1000 artworks by Vincent van Gogh from the permanent collection of the [Van Gogh Museum](https://vangoghmuseum.nl/) in Amsterdam.

All artworks were translated from the visual to the auditory domain using [SynVAE](https://personads.me/x/synvae), a machine learning model which generates consistent musical representations for image data. This means that similar images should produce similar music as well.

The intended use of these short musical samples is to provide a broad overview of the paintings in the museum. They should allow people with visual impairments to quickly assess whether a piece is of interest to them and whether to focus their attention on it further by, for example, listening to the audio guide or some other detailed description.

Each artwork JPEG file is accompanied by a MIDI representation of the same name. Since many artworks share a title, files are uniquely numbered in alphabetical order with titles being provided in `meta.txt`.

```
...
603	Self-Portrait (1887)
604	Self-Portrait (1887)
605	Self-Portrait as a Painter (1887 - 1888)
606	Self-Portrait as a Painter (1886)
...
```

Although the artworks themselves are in the public domain, we kindly ask that you use the files in this archive for non-commercial purposes only and cite the [SynVAE](https://personads.me/x/synvae) paper if you do.

We hope you find this small proof of concept interesting and enjoyable.