/*
* ltstorage - main js
*/

/*
* variable init
*/

var curPage = ((window.location.hash.substr(1).length > 0) ? parseInt(window.location.hash.substr(1), 10) : 0);
var maxPage = document.getElementsByClassName('page').length-1;
var curStack = 0;
var curImage = 0;
var isImageStackOpen = false;

/*
* ui event setup
*/

var pages = document.getElementsByClassName('page');
for (var p = 0; p < pages.length; p++) {
    pages[p].id = p;
    var pageStacks = pages[p].getElementsByClassName('image-stack');
    for (var s = 0; s < pageStacks.length; s++) {
        pageStacks[s].id = p + '-' + s;
        var stackImages = pageStacks[s].getElementsByClassName('image');
        for (var i = 0; i < stackImages.length; i++) {
            stackImages[i].id = p + '-' + s + '-' + i;
            if (stackImages[i].classList.contains('image-cover')) {
                appendCoverImage(stackImages[i].getElementsByTagName('img')[0].src);
            }
        }
    }
}

var imageStacks = document.getElementsByClassName('image-stack');
for (var i = 0; i < imageStacks.length; i++) {
    imageStacks[i].onclick = function() { onClickImageStack(this) }.bind(imageStacks[i]);
}

document.onkeydown = function(_e) {
    if (!isImageStackOpen) {
        if (_e.keyCode == 39) {
            nextPage();
        } else if (_e.keyCode == 37) {
            previousPage();
        }
    } else {
        if (_e.keyCode == 39) {
            nextImage();
        } else if (_e.keyCode == 37) {
            previousImage();
        } else if (_e.keyCode == 27) {
            onClickImageStack(document.getElementsByClassName('image-stack-open')[0]);
        }
    }
};

window.onload = function() {
    document.getElementsByClassName('overlay-loading')[0].style.animation = '3s forwards animation-overlay-loading-hide';
    document.getElementById(curPage).scrollIntoView();
};

/*
* page functions
*/

function nextPage() {
    if (curPage < maxPage) {
        curPage++;
        document.getElementById(curPage).scrollIntoView();
        window.location.hash = "#" + curPage;
        if (document.getElementById(curPage).classList.contains('page-animated')) {
            var pageNodes = document.getElementById(curPage).getElementsByTagName('*');
            for (var pn = 0; pn < pageNodes.length; pn++) {
                pageNodes[pn].style.animationPlayState = 'running';
            }
        }
    }
}

function previousPage() {
    if (curPage > 0) {
        curPage--;
        document.getElementById(curPage).scrollIntoView();
        window.location.hash = "#" + curPage;
    }
}

/*
* image functions
*/

function nextImage() {
    if (curImage < document.getElementById(curPage + '-' + curStack).getElementsByClassName('image').length - 1) {
        document.getElementById(curPage + '-' + curStack + '-' + curImage).classList.toggle('image-active');
        curImage++;
        document.getElementById(curPage + '-' + curStack + '-' + curImage).classList.toggle('image-active');
    } else {
        onClickImageStack(document.getElementsByClassName('image-stack-open')[0]);
    }
}

function previousImage() {
    if (curImage > 0) {
        document.getElementById(curPage + '-' + curStack + '-' + curImage).classList.toggle('image-active');
        curImage--;
        document.getElementById(curPage + '-' + curStack + '-' + curImage).classList.toggle('image-active');
    }
}

/*
* ui event functions
*/

function onClickImageStack(_el) {
    curPage = _el.id.split('-')[0];
    curStack = _el.id.split('-')[1];
    curImage = 0;
    var stackImages = _el.getElementsByClassName('image');
    for (var i = 0; i < stackImages.length; i++) {
        if (stackImages[i].classList.contains('image-active')) {
            curImage = i;
        }
        if (stackImages[i].getElementsByTagName('video').length > 0) {
            stackImages[i].getElementsByTagName('video')[0].controls = !stackImages[i].getElementsByTagName('video')[0].controls;
        }
    }
    stackImages[curImage].classList.add('image-active');
    _el.classList.toggle("image-stack-open");
    _el.classList.toggle("image-stack");
    isImageStackOpen = !isImageStackOpen;
}

/*
* helper functions
*/

function appendCoverImage(_src) {
    var coverPage = document.getElementsByClassName('page-cover')[0];
    if (coverPage.getElementsByClassName('page-cover-image').length < 3) {
        var coverImageNode = document.createElement('img');
        coverImageNode.classList.add('page-cover-image', 'centered');
        coverImageNode.alt = 'cover image';
        coverImageNode.src = _src;
        coverPage.appendChild(coverImageNode);
    }
}
